@extends(activeTemplate() .'layouts.app')

@section('content')
    <div class="row">
        @if($general->notice != NULL && $general->notice != '<br>')
        <div class="col-md-12">
            <div class="card border-primary mb-3">
                <div class="card-header">@lang('Notice')</div>
                <div class="card-body">
                   @php echo $general->notice; @endphp

                    </div>
            </div>
        </div>
        @endif
        @if(auth()->user()->plan_id == 0)

        @if($general->free_user_notice != NULL && $general->free_user_notice !=  '<br>')

        <div class="col-md-12">
            <div class="card border-secondary mb-3">
                <div class="card-header">@lang('Notice')</div>
                <div class="card-body">


                    @php echo $general->free_user_notice; @endphp

                </div>
            </div>
        </div>
                @endif
            @endif
    </div>

    <div class="row">

        <div class="col-xl-4 col-lg-6 col-sm-6">
            <div class="dashboard-w2 slice bg-red border-radius-5">
                <div class="details">
                    <h2 class="amount mb-2 font-weight-bold">{{$general->cur_sym}}{{formatter_money(Auth::user()->balance)}} </h2>
                    <h4 class="mb-3">@lang('Current Balance')</h4>
                    <a href="{{route('user.deposit.history')}}" class="btn btn-sm btn-neutral">@lang('View all')</a>
                </div>
                <div class="icon">
                    <i class="fa fa-money"></i>
                </div>
            </div>
        </div>


        <div class="col-xl-4 col-lg-6 col-sm-6">
            <div class="dashboard-w2 slice bg-default border-radius-5">
                <div class="details">
                    <h2 class="amount mb-2 font-weight-bold">{{$general->cur_sym}}{{formatter_money($total_deposit)}} </h2>
                    <h4 class="mb-3">@lang('Total Deposit')</h4>
                    <a href="{{route('user.deposit.history')}}" class="btn btn-sm btn-neutral">@lang('View all')</a>
                </div>
                <div class="icon">
                    <i class="fa fa-money"></i>
                </div>
            </div>
        </div>


        <div class="col-xl-4 col-lg-6 col-sm-6">
            <div class="dashboard-w2 slice bg-info border-radius-5">
                <div class="details">
                    <h2 class="amount mb-2 font-weight-bold">{{$general->cur_sym}}{{formatter_money($total_withdraw)}} </h2>
                    <h4 class="mb-3">@lang('Total Withdraw')</h4>
                    <a href="{{route('user.withdraw')}}" class="btn btn-sm btn-neutral">@lang('View all')</a>
                </div>
                <div class="icon">
                    <i class="fa fa-money"></i>
                </div>
            </div>
        </div>
        <div class="col-xl-4 col-lg-6 col-sm-6">
            <div class="dashboard-w2 slice bg-primary border-radius-5">
                <div class="details">
                    <h2 class="amount mb-2 font-weight-bold">{{formatter_money($complete_withdraw)}} </h2>
                    <h4 class="mb-3">@lang('Complete Withdraw')</h4>
                    <a href="{{route('user.withdraw')}}" class="btn btn-sm btn-neutral">@lang('View all')</a>
                </div>
                <div class="icon">
                    <i class="fa fa-check-circle-o"></i>
                </div>
            </div>
        </div>
        <div class="col-xl-4 col-lg-6 col-sm-6">
            <div class="dashboard-w2 slice bg-purple border-radius-5">
                <div class="details">
                    <h2 class="amount mb-2 font-weight-bold">{{formatter_money($pending_withdraw)}} </h2>
                    <h4 class="mb-3">@lang('Pending Withdraw')</h4>
                    <a href="{{route('user.withdraw')}}" class="btn btn-sm btn-neutral">@lang('View all')</a>
                </div>
                <div class="icon">
                    <i class="fa fa-spinner"></i>
                </div>
            </div>
        </div>
        <div class="col-xl-4 col-lg-6 col-sm-6">
            <div class="dashboard-w2 slice bg-danger border-radius-5">
                <div class="details">
                    <h2 class="amount mb-2 font-weight-bold">{{formatter_money($reject_withdraw)}} </h2>
                    <h4 class="mb-3">@lang('Reject Withdraw')</h4>
                    <a href="{{route('user.withdraw')}}" class="btn btn-sm btn-neutral">@lang('View all')</a>
                </div>
                <div class="icon">
                    <i class="fa fa-ban"></i>
                </div>
            </div>
        </div>

    </div>

@endsection
