@extends(activeTemplate() .'layouts.master')

@section('content')
    @include(activeTemplate() .'partials.front_br')




    <section class="section-padding gradient-overlay cl-white">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-8 col-lg-8 col-md-12 col-sm-12">
                    <div class="section-title centered">
                        <h2>Any asking to us?</h2>
                        <p>There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which</p>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-xl-6">
                    <div class="contact-form">
                        <form action="{{route('send.mail.contact')}}" method="post">
                            @csrf
                            <h4>Get in touch</h4>
                            <p>Send us a message if you need any help</p>
                            <input type="text" value="{{old('name')}}" name="name" placeholder="Name">
                            <input type="text" placeholder="Phone">
                            <input type="email" value="{{old('email')}}" name="email" placeholder="Email">
                            <textarea name="message" rows="4" placeholder="Your message">{{old('message')}}</textarea>
                            <button type="submit" class="bttn-mid btn-fill">Send message</button>
                        </form>
                    </div>
                </div>
                <div class="col-xl-6">
                    <div class="contact-content">
                        <h4>@lang('Contact Details')</h4>
                        <p>{{$general->contact_address}}</p>
                        <h5>@lang('Call for emergencies')</h5>
                        <p>{{$general->contact_phone}}</p>

                        <h5>@lang('Mail us for support') </h5>
                        <p>{{$general->contact_mail}}</p>

                        <div class="social">
                            @foreach($social as $item)
                                <a href="{{$item->value->url}}" title="{{$item->value->title}}" >@php echo $item->value->icon; @endphp</a>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>





@stop