@extends('admin.layouts.app')

@section('panel')
    <div class="row">

        <div class="col-lg-12">
            <div class="card">
                <div class="table-responsive table-responsive-xl">
                    <table class="table align-items-center table-light">
                        <thead>
                        <tr>
                            <th scope="col">Name</th>
                            <th scope="col">Amount</th>
                            <th scope="col">Business Volume (BV)</th>
                            <th scope="col">Sponsor/Referral Commission</th>
                            <th scope="col">Commission to tree</th>
                            <th scope="col">Status</th>
                            <th scope="col">Action</th>
                        </tr>
                        </thead>
                        <tbody>
                        @forelse($plans as $plan)
                            <tr>
                                <td>{{ $plan->name }}</td>
                                <td>{{$general->cur_sym}}{{ formatter_money($plan->amount) }}</td>

                                <td>{{ $plan->bv }}</td>
                                <td>{{$general->cur_sym}}{{ formatter_money($plan->ref_com) }}</td>
                                <td>{{$general->cur_sym}}{{ formatter_money($plan->com_to_tree) }}</td>
                                <td>

                                    <span class="badge badge-dot">
                                    @if($plan->status == 1)
                                            <i class="bg-success"></i>
                                            <span class="status">active</span>
                                        @else
                                            <i class="bg-danger"></i>
                                            <span class="status">disabled</span>
                                        @endif
                                </span>
                                </td>
                                <td>

                                    <button class="btn btn-primary edit" data-id="{{ $plan->id }}"
                                            data-name="{{ $plan->name }}" data-status="{{ $plan->status }}"
                                            data-bv="{{ $plan->bv }}" data-amount="{{ formatter_money($plan->amount) }}"
                                            data-ref_com="{{ formatter_money($plan->ref_com) }}"
                                            data-com_to_tree="{{ formatter_money($plan->com_to_tree) }}"><i class="fa fa-pencil"></i>
                                    </button>

                                </td>
                            </tr>



                        @empty
                            <tr>
                                <td class="text-muted text-center" colspan="100%">{{ $empty_message }}</td>
                            </tr>
                        @endforelse
                        </tbody>
                    </table>
                </div>
                <div class="card-footer py-4">
                    <nav aria-label="...">
                        {{ $plans->appends($_GET)->links() }}
                    </nav>
                </div>
            </div>
        </div>
    </div>





    <div id="edit-plan" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit MLM plan</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>

                <form method="post" action="{{route('admin.plan.update')}}">
                    @csrf
                    <div class="modal-body">
                        <input class="form-control plan_id" type="hidden" name="id">
                        <div class="form-group">
                            <label> Name :</label>
                            <input class="form-control form-control-lg name" name="name"
                                   required>
                        </div>

                        <div class="form-group">
                            <label> Amount </label>
                            <div class="input-group">
                                <div class="input-group-prepend"><span
                                            class="input-group-text">{{$general->cur_sym}} </span></div>
                                <input type="text" class="form-control  form-control-lg amount" name="amount" required>
                            </div>
                        </div>
                        <div class="form-group">
                            <label> Business Value (BV) <br><span class="small text-danger">When someone buy this plan, every member from his up-lines (tree) will get this Business Volume which will be used for matching bonus.</span>  </label>
                            <input class="form-control form-control-lg bv" name="bv"
                            >
                        </div>

                        <div class="form-group">
                            <label> Referral Commission <br><span class="small text-danger">When a User with this Plan refer someone and reffered user buy a plan, First user (referral) will get this amount.</span> </label>
                            <input class="form-control form-control-lg ref_com" name="ref_com"
                                   required>
                        </div>
                        <div class="form-group">
                            <label> Commission to tree <br><span class="small text-danger">When someone buy this plan, every member from his up-lines (tree) will get this amount.</span> </label>
                            <input class="form-control form-control-lg com_to_tree" name="com_to_tree"
                                   required>
                        </div>

                        <div class="form-group">
                            <label> Select Status :</label>
                            <select name="status" id="event-status" class="form-control form-control-lg status"
                                    required>
                                <option value="1">Active</option>
                                <option value="0">Disabled</option>
                            </select>
                            <br>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn  btn-dark" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-success">Update</button>

                    </div>
                </form>

            </div>
        </div>
    </div>




    <div id="add-plan" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit MLM plan</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>

                <form method="post" action="{{route('admin.plan.create')}}">
                    @csrf
                    <div class="modal-body">
                        <input class="form-control plan_id" type="hidden" name="id">
                        <div class="form-group">
                            <label> Name :</label>
                            <input type="text" class="form-control form-control-lg " name="name"
                                   required>
                        </div>

                        <div class="form-group">
                            <label> Amount </label>
                            <div class="input-group">
                                <div class="input-group-prepend"><span
                                            class="input-group-text">{{$general->cur_sym}} </span></div>
                                <input type="text" class="form-control  form-control-lg " name="amount" required>
                            </div>
                        </div>
                        <div class="form-group">
                            <label> Business Value (BV) </label>
                            <input class="form-control form-control-lg " type="number" name="bv"
                                   required>
                        </div>

                        <div class="form-group">
                            <label> Commission to sponsor/reefer </label>
                            <input class="form-control form-control-lg " type="text" name="ref_com"
                                   required>
                        </div>
                        <div class="form-group">
                            <label> Commission to tree </label>
                            <input class="form-control form-control-lg " type="text" name="com_to_tree"
                                   required>
                        </div>

                        <div class="form-group">
                            <label> Select Status :</label>
                            <select name="status" id="event-status" class="form-control form-control-lg status"
                                    required>
                                <option value="1">Active</option>
                                <option value="0">Disabled</option>
                            </select>
                            <br>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Create</button>
                        <button type="button" class="btn btn-danger" data-dismiss="modal">Cancel</button>
                    </div>
                </form>

            </div>
        </div>
    </div>




@endsection

@push('breadcrumb-plugins')
    <a class="btn btn-success add-plan"><i class="fa fa-fw fa-plus"></i>Add New</a>
@endpush


@push('script')
    <script>
        $('.edit').on('click', function () {
            var modal = $('#edit-plan');
            modal.find('.name').val($(this).data('name'));
            modal.find('.amount').val($(this).data('amount'));
            modal.find('.bv').val($(this).data('bv'));
            modal.find('.ref_com').val($(this).data('ref_com'));
            modal.find('.com_to_tree').val($(this).data('com_to_tree'));
            modal.find('.status').val($(this).data('status'));
            modal.find('input[name=id]').val($(this).data('id'));
            modal.modal('show');
        });

        $('.add-plan').on('click', function () {
            var modal = $('#add-plan');
            modal.modal('show');
        });
    </script>
@endpush